/*
 * Decompiled with CFR 0.152.
 */
import java.io.UTFDataFormatException;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextArea {
    private int mls;
    private int ActiveUp = -1;
    private int ActiveDown = -1;
    private int position;
    private int emptylines;
    private boolean scrollbar;
    private String[][] scrollbuffer;
    private int bufindex;
    private UIHandler uihandler;
    private final int MAX_LINES;
    private int wHeight;
    private int wWidth;
    private int wTop;
    private int wLeft;
    private int hTop;
    public static final int wScrollBar = 3;
    public static final char cBegin = '\r';
    public static final char cRem = '\u001b';
    public static final char cbUTF = '\u0017';
    public static final char ceUTF = '\u0018';
    public static final char cbURL = '\u0019';
    public static final char ceURL = '\u001a';
    public static final char cCHAR = '\u001e';

    public TextArea(UIHandler uIHandler, int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.scrollbar = bl;
        this.uihandler = uIHandler;
        this.wHeight = n2;
        this.wWidth = n;
        this.wTop = n3;
        this.hTop = n4;
        this.wLeft = n5;
        this.mls = n2 / uIHandler.FontHeight;
        this.MAX_LINES = Database.BufLines;
        this.clear();
    }

    public void setSize(int n, int n2, int n3) {
        boolean bl = this.isAtEndpos();
        this.wHeight = n2;
        this.wWidth = n;
        this.wTop = n3;
        this.mls = this.wHeight / this.uihandler.FontHeight;
        if (bl) {
            this.End();
        }
    }

    public boolean LineDown() {
        if (this.ActiveDown < this.MAX_LINES - this.emptylines - 1 || this.position + this.mls < this.MAX_LINES - this.emptylines) {
            if (this.ActiveDown + 1 > this.position + this.mls) {
                ++this.position;
                return true;
            }
            ++this.ActiveDown;
            this.ActiveUp = this.ActiveDown++;
            while (this.ActiveDown < this.MAX_LINES - this.emptylines && this.scrollbuffer[(this.ActiveDown + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
                ++this.ActiveDown;
            }
            if (this.ActiveDown <= this.MAX_LINES - this.emptylines) {
                --this.ActiveDown;
            }
            if (this.ActiveUp + 1 > this.position + this.mls) {
                ++this.position;
            }
            return true;
        }
        return false;
    }

    public boolean LineUp() {
        if (this.ActiveUp > 0 || this.position > 0) {
            if (this.ActiveUp < this.position) {
                --this.position;
                return true;
            }
            --this.ActiveUp;
            this.ActiveDown = this.ActiveUp;
            while (this.ActiveUp > 0 && this.scrollbuffer[(this.ActiveUp + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
                --this.ActiveUp;
            }
            if (this.ActiveDown < this.position) {
                --this.position;
            }
            return true;
        }
        return false;
    }

    public boolean PageDown() {
        if (this.position + this.mls >= this.MAX_LINES - this.emptylines) {
            return this.End();
        }
        if (this.ActiveUp <= this.position + this.mls - 1 && this.ActiveDown >= this.position + this.mls - 1) {
            this.position += this.mls;
        }
        if (this.position + this.mls >= this.MAX_LINES - this.emptylines) {
            return this.End();
        }
        this.ActiveUp = this.ActiveDown = this.position + this.mls - 1;
        while (this.ActiveUp > 0 && this.scrollbuffer[(this.ActiveUp + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            --this.ActiveUp;
        }
        this.ActiveDown = this.ActiveUp + 1;
        while (this.ActiveDown < this.MAX_LINES - this.emptylines && this.scrollbuffer[(this.ActiveDown + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            ++this.ActiveDown;
        }
        if (this.ActiveDown < this.MAX_LINES - this.emptylines) {
            --this.ActiveDown;
        }
        return true;
    }

    public boolean PageUp() {
        if (this.position == 0) {
            return this.Home();
        }
        if (this.ActiveUp <= this.position && this.ActiveDown >= this.position) {
            this.position -= this.mls;
        }
        if (this.position < 0) {
            return this.Home();
        }
        this.ActiveUp = this.ActiveDown = this.position;
        while (this.ActiveUp > 0 && this.scrollbuffer[(this.ActiveUp + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            --this.ActiveUp;
        }
        this.ActiveDown = this.ActiveUp + 1;
        while (this.ActiveDown < this.MAX_LINES - this.emptylines && this.scrollbuffer[(this.ActiveDown + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            ++this.ActiveDown;
        }
        if (this.ActiveDown < this.MAX_LINES - this.emptylines) {
            --this.ActiveDown;
        }
        return true;
    }

    public boolean End() {
        this.position = this.MAX_LINES - this.emptylines - this.mls;
        if (this.position < 0) {
            this.position = 0;
        }
        this.ActiveUp = this.ActiveDown = this.MAX_LINES - this.emptylines - 1;
        while (this.ActiveUp > 0 && this.scrollbuffer[(this.ActiveUp + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            --this.ActiveUp;
        }
        return true;
    }

    public boolean Home() {
        if (this.position == 0 && this.ActiveUp == 0) {
            return false;
        }
        this.ActiveDown = 0;
        this.ActiveUp = 0;
        this.position = 0;
        ++this.ActiveDown;
        while (this.ActiveDown < this.MAX_LINES - this.emptylines && this.scrollbuffer[(this.ActiveDown + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            ++this.ActiveDown;
        }
        if (this.ActiveDown < this.MAX_LINES - this.emptylines) {
            --this.ActiveDown;
        }
        return true;
    }

    public String GetSelectedText(boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (this.ActiveUp == -1 || this.ActiveDown == -1) {
            return "";
        }
        for (int i = this.ActiveUp; i <= this.ActiveDown; ++i) {
            String[] stringArray = this.scrollbuffer[this.emptylines == 0 ? (i + this.bufindex) % this.MAX_LINES : i];
            if (i > this.ActiveUp && bl3) {
                string = string + "%n%";
                n3 = -1;
                n4 = -1;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                c = stringArray[j].charAt(0);
                String string2 = Utils.ColorToCode(stringArray[j].substring(1));
                if (string2.charAt(0) == '\r') {
                    string2 = string2.substring(1);
                }
                if (!bl2) {
                    string2 = Utils.Remove(string2, new String[]{"\u0019", "\u001a", "\u0017", "\u0018"});
                }
                if (bl) {
                    if ((c & 0x100) != 0) {
                        if (!bl4) {
                            string = string + "%b%";
                            bl4 = true;
                        }
                    } else if (bl4) {
                        string = string + "%b%";
                        bl4 = false;
                    }
                    if ((c & 0x200) != 0) {
                        if (!bl5) {
                            string = string + "%i%";
                            bl5 = true;
                        }
                    } else if (bl5) {
                        string = string + "%i%";
                        bl5 = false;
                    }
                    if ((c & 0x400) != 0) {
                        if (!bl6) {
                            string = string + "%u%";
                            bl6 = true;
                        }
                    } else if (bl6) {
                        string = string + "%u%";
                        bl6 = false;
                    }
                    n = c & 0xF;
                    n2 = c >> 4 & 0xF;
                    if (n3 != n || n4 != n2) {
                        bl7 = (c & 0xFFFFF7FF) == -2049;
                        string = string + "%c%" + (!bl7 ? (n < 10 ? "0" + n : "" + n) + (n4 != n2 && j > 0 ? "," + (n2 < 10 ? "0" + n2 : "" + n2) : "") : "%c%");
                    }
                    n3 = n;
                    n4 = n2;
                }
                string = string + string2;
            }
        }
        return string + (bl && !bl7 ? "%c%" : "");
    }

    public boolean isAtEndpos() {
        return this.ActiveDown == this.MAX_LINES - this.emptylines - 1;
    }

    private void addLine(String[] stringArray) {
        this.scrollbuffer[this.bufindex] = stringArray;
        this.bufindex = (this.bufindex + 1) % this.MAX_LINES;
        if (this.emptylines > 0) {
            --this.emptylines;
        } else if (this.ActiveDown > 0) {
            --this.position;
            if (this.position < 0) {
                this.position = 0;
            }
            --this.ActiveUp;
            if (this.ActiveUp < 0) {
                this.ActiveUp = 0;
            }
            --this.ActiveDown;
        }
    }

    public void addText(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        Vector<Character> vector2 = new Vector<Character>();
        Font font = Font.getFont((int)0, (int)0, (int)Database.FontSize);
        int n = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = null;
            String string2 = null;
            char c = stringArray[i].charAt(0);
            stringArray[i] = stringArray[i].substring(1);
            if ((c & 0x800) == 2048) {
                c = (char)(c ^ 0x800);
            }
            font = Font.getFont((int)0, (int)(c >> 8 & 0xF), (int)Database.FontSize);
            String[] stringArray2 = Utils.splitString(stringArray[i], " ");
            for (int j = 0; j < stringArray2.length; ++j) {
                int n2;
                if (string2 == null) {
                    string2 = stringArray2[j];
                    if (n + font.stringWidth(string2) > this.wWidth - 5) {
                        if (bl) {
                            string = "";
                            string2 = " " + string2;
                        } else {
                            int n3 = 1;
                            while (n + font.stringWidth(string2.substring(0, n3)) < this.wWidth - 5) {
                                ++n3;
                            }
                            for (n2 = 0; n2 < 3; ++n2) {
                                try {
                                    if (n3 <= 0) break;
                                    Utils.decodeUTF8(Utils.stringToByteArray(string2.substring(0, n3), Database.Encoding), false);
                                    break;
                                }
                                catch (UTFDataFormatException uTFDataFormatException) {
                                    --n3;
                                    continue;
                                }
                            }
                            if (n3 <= 0) {
                                n3 = 1;
                            }
                            string = string2.substring(0, n3 - 1);
                            string2 = string2.substring(n3 - 1);
                        }
                        n = 0;
                    }
                    n += font.stringWidth(string2);
                } else if (n + font.stringWidth(" " + stringArray2[j]) > this.wWidth - 5) {
                    string = string2;
                    string2 = " " + stringArray2[j];
                    n = font.stringWidth(string2);
                } else {
                    string2 = string2 + " " + stringArray2[j];
                    n += font.stringWidth(" " + stringArray2[j]);
                }
                while (string != null) {
                    if (!string.equals("")) {
                        vector.addElement(string);
                        vector2.addElement(new Character(c));
                    }
                    String[] stringArray3 = new String[vector.size()];
                    for (n2 = 0; n2 < stringArray3.length; ++n2) {
                        stringArray3[n2] = ((Character)vector2.elementAt(n2)).charValue() + (String)vector.elementAt(n2);
                    }
                    this.addLine(stringArray3);
                    vector.removeAllElements();
                    vector2.removeAllElements();
                    if (font.stringWidth(string2) > this.wWidth - 5) {
                        n2 = 1;
                        while (font.stringWidth(string2.substring(0, n2)) < this.wWidth - 5) {
                            ++n2;
                        }
                        for (int k = 0; k < 3; ++k) {
                            try {
                                if (n2 <= 0) break;
                                Utils.decodeUTF8(Utils.stringToByteArray(string2.substring(0, n2 - 1), Database.Encoding), false);
                                break;
                            }
                            catch (UTFDataFormatException uTFDataFormatException) {
                                --n2;
                                continue;
                            }
                        }
                        if (n2 <= 0) {
                            n2 = 1;
                        }
                        string = string2.substring(0, n2 - 1);
                        string2 = string2.substring(n2 - 1);
                        n = font.stringWidth(string2);
                        continue;
                    }
                    string = null;
                }
            }
            vector.addElement(string2);
            vector2.addElement(new Character(c));
            bl = string2.length() > 0 && string2.charAt(string2.length() - 1) == ' ';
        }
        if (vector.size() > 0 && vector2.size() > 0) {
            String[] stringArray4 = new String[vector.size()];
            for (int i = 0; i < stringArray4.length; ++i) {
                stringArray4[i] = ((Character)vector2.elementAt(i)).charValue() + (String)vector.elementAt(i);
            }
            this.addLine(stringArray4);
            vector.removeAllElements();
            vector2.removeAllElements();
        }
    }

    private void DrawStylusLines(Graphics graphics) {
        int n = this.uihandler.FontHeight;
        if (n < this.wWidth / 15) {
            n = this.wWidth / 15;
        }
        graphics.setColor(180, 180, 255);
        graphics.drawLine(n * 2, this.wTop + n, this.wWidth - n * 3, this.wTop + n);
        graphics.drawLine(0, this.wTop, this.wWidth, this.wTop);
        graphics.drawLine(0, this.wTop + n * 2, n * 2, this.wTop + n * 2);
        graphics.drawLine(n * 2, this.wTop, n * 2, this.wTop + n * 2);
        graphics.drawLine(this.wWidth - n * 3, this.wTop + n * 2, this.wWidth - n, this.wTop + n * 2);
        graphics.drawLine(this.wWidth - n * 3, this.wTop, this.wWidth - n * 3, this.wTop + n * 2);
        graphics.drawLine(n * 2, this.wTop + this.wHeight - n, this.wWidth - n * 3, this.wTop + this.wHeight - n);
        graphics.drawLine(0, this.wTop + this.wHeight, this.wWidth, this.wTop + this.wHeight);
        graphics.drawLine(0, this.wTop + this.wHeight - n * 2, n * 2, this.wTop + this.wHeight - n * 2);
        graphics.drawLine(n * 2, this.wTop + this.wHeight - n * 2, n * 2, this.wTop + this.wHeight);
        graphics.drawLine(this.wWidth - n * 3, this.wTop + this.wHeight - n * 2, this.wWidth - n, this.wTop + this.wHeight - n * 2);
        graphics.drawLine(this.wWidth - n * 3, this.wTop + this.wHeight - n * 2, this.wWidth - n * 3, this.wTop + this.wHeight);
        graphics.drawLine(n, this.wTop + n * 2, n, this.wTop + this.wHeight - n * 2);
        graphics.drawLine(this.wWidth - n * 2, this.wTop + n * 2, this.wWidth - n * 2, this.wTop + this.wHeight - n * 2);
        graphics.drawLine(this.wWidth - n, this.wTop, this.wWidth - n, this.wTop + this.wHeight);
        graphics.drawLine(this.wWidth - n * 2, this.wTop + this.wHeight - n, this.wWidth - n, this.wTop + this.wHeight - n);
        graphics.drawLine(this.wWidth - n * 2, this.wTop + this.wHeight - n, this.wWidth - n * 2, this.wTop + this.wHeight);
        int n2 = this.wWidth / this.uihandler.NumsWind;
        for (int i = 1; i < this.uihandler.NumsWind; ++i) {
            graphics.drawLine(i * n2, this.hTop, i * n2, this.hTop + this.uihandler.FontHeight - 1);
        }
    }

    public boolean SetPos(int n) {
        if ((n = n * (this.MAX_LINES - this.emptylines - this.mls) / (this.wHeight - this.uihandler.FontHeight)) == this.position) {
            return false;
        }
        if (n > this.position) {
            this.position = n;
            this.ActiveUp = this.ActiveDown = this.position + this.mls - 1;
        }
        if (n < this.position) {
            this.ActiveDown = this.position = n;
            this.ActiveUp = this.position;
        }
        while (this.ActiveUp > 0 && this.scrollbuffer[(this.ActiveUp + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            --this.ActiveUp;
        }
        this.ActiveDown = this.ActiveUp + 1;
        while (this.ActiveDown < this.MAX_LINES - this.emptylines && this.scrollbuffer[(this.ActiveDown + this.bufindex + this.emptylines) % this.MAX_LINES][0].charAt(1) != '\r') {
            ++this.ActiveDown;
        }
        if (this.ActiveDown < this.MAX_LINES - this.emptylines) {
            --this.ActiveDown;
        }
        if (this.position + this.mls >= this.MAX_LINES - this.emptylines) {
            return this.End();
        }
        return true;
    }

    public void draw(Graphics graphics) {
        int n;
        graphics.setFont(this.uihandler.font);
        graphics.setColor(Utils.getColor(Database.Theme == jmIrc.DarkThemes ? 0 : 1));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.mls; ++n) {
            boolean bl;
            int n6 = 1 + this.wLeft;
            int n7 = (this.bufindex + this.emptylines + this.position + n) % this.scrollbuffer.length;
            String[] stringArray = this.scrollbuffer[n7];
            char c = '\uffffffff';
            if (stringArray == null) break;
            if (stringArray[0].charAt(1) == ' ') {
                n6 += graphics.getFont().stringWidth(" ");
            }
            boolean bl2 = bl = n >= this.ActiveUp - this.position && n <= this.ActiveDown - this.position;
            if (bl) {
                if (Database.Theme == jmIrc.DarkThemes) {
                    graphics.setColor(30, 30, 30);
                } else {
                    graphics.setColor(225, 225, 225);
                }
                graphics.fillRect(this.wLeft, this.wTop + n * this.uihandler.FontHeight, this.wWidth - 1, this.uihandler.FontHeight);
                if (Database.Theme == jmIrc.DarkThemes) {
                    graphics.setColor(55, 55, 55);
                } else {
                    graphics.setColor(200, 200, 200);
                }
                if (n == this.ActiveUp - this.position) {
                    graphics.drawLine(this.wLeft, this.wTop + n * this.uihandler.FontHeight, this.wWidth - 1, this.wTop + n * this.uihandler.FontHeight);
                }
                if (n == this.ActiveDown - this.position) {
                    graphics.drawLine(this.wLeft, this.wTop + (n + 1) * this.uihandler.FontHeight - 1, this.wWidth - 1, this.wTop + (n + 1) * this.uihandler.FontHeight - 1);
                }
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                char c2;
                char c3 = stringArray[i].charAt(0);
                if ((c3 & 0x800) == 2048) {
                    c3 = (char)(c3 ^ 0x800);
                }
                if ((c2 = (string = stringArray[i].substring(1)).charAt(0)) == ' ' && string.length() > 1) {
                    c2 = string.charAt(1);
                }
                if (c2 == '\r' || c2 == '\u0019' || c2 == '\u001a' || c2 == '\u0017' || c2 == '\u0018') {
                    string = string.charAt(0) == ' ' ? ' ' + string.substring(2) : string.substring(1);
                }
                if (c2 == '\r') {
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                }
                boolean bl3 = false;
                if (c2 == '\u0019') {
                    boolean bl4 = bl3 = ++n2 > 0;
                }
                if (c2 == '\u001a') {
                    boolean bl5 = bl3 = ++n3 > 0 && n2 > 0;
                }
                if (n3 > n2) {
                    --n3;
                }
                if (c2 == '\u0017') {
                    boolean bl6 = bl3 = ++n4 > 0;
                }
                if (c2 == '\u0018') {
                    boolean bl7 = bl3 = ++n5 > 0 && n4 > 0;
                }
                if (n5 > n4) {
                    --n5;
                }
                if (string.equals("")) continue;
                if (string.charAt(0) == ' ' && i == 0) {
                    string = string.substring(1);
                }
                if (c3 != c || bl3 || bl || Database.FindURLs == 2) {
                    c2 = c3;
                    if (n2 > n3 && (bl || Database.FindURLs == 2)) {
                        c2 = (char)(c2 | 0x400);
                    }
                    graphics.setFont(Font.getFont((int)0, (int)(c2 >> 8 & 0xF), (int)Database.FontSize));
                    if (!bl) {
                        graphics.setColor(Utils.getColor(c3 >> 4 & 0xF));
                        graphics.fillRect(n6, this.wTop + n * this.uihandler.FontHeight, graphics.getFont().stringWidth(string), this.uihandler.FontHeight);
                    }
                    if (n2 > n3 && (bl || Database.FindURLs == 2)) {
                        graphics.setColor(Utils.getColor(12));
                    } else {
                        graphics.setColor(Utils.getColor(c3 & 0xF));
                    }
                    c = c3;
                }
                try {
                    if (n4 > n5 && bl) {
                        string = Utils.decodeUTF8(Utils.stringToByteArray(string, Database.Encoding), true);
                    }
                }
                catch (UTFDataFormatException uTFDataFormatException) {
                    // empty catch block
                }
                graphics.drawString(string, n6, this.wTop + n * this.uihandler.FontHeight, 20);
                n6 += graphics.getFont().stringWidth(string);
            }
        }
        if (Window.Stylus) {
            this.DrawStylusLines(graphics);
        }
        if (this.scrollbar && this.MAX_LINES - this.emptylines > this.mls) {
            n = this.position * (this.wHeight - this.uihandler.FontHeight) / (this.MAX_LINES - this.emptylines - this.mls);
            if (Database.Theme == jmIrc.DarkThemes) {
                graphics.setColor(55, 55, 55);
            } else {
                graphics.setColor(200, 200, 200);
            }
            graphics.fillRect(this.wWidth - 3, this.wTop, 3, this.wHeight);
            if (Database.Theme == jmIrc.DarkThemes) {
                graphics.setColor(255, 255, 255);
            } else {
                graphics.setColor(0, 0, 0);
            }
            graphics.fillRect(this.wWidth - 3, this.wTop + n, 3, this.uihandler.FontHeight);
        }
    }

    public void clear() {
        this.scrollbuffer = new String[this.MAX_LINES][];
        this.emptylines = this.MAX_LINES;
        this.ActiveUp = -1;
        this.ActiveDown = -1;
        this.bufindex = 0;
        this.position = 0;
        System.gc();
    }
}

