/*
 * Decompiled with CFR 0.152.
 */
package borisplus.j2me.mail;

import java.util.Date;
import java.util.Vector;

public class Message {
    public static final String CRLF = "\r\n";
    public static final String CONTYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTYPE_TEXT_HTML = "text/html";
    public static final String CONTYPE_AUDIO_MIDI = "audio/midi";
    public static final String CHARSET_KOI8_R = "koi8-r";
    public static final String CHARSET_WINDOWS_1251 = "windows-1251";
    public static final String CHARSET_UTF_8 = "utf-8";
    public static final String CTE_BASE64 = "base64";
    public static final String CTE_QUOTED_PRINTABLE = "quoted-printable";
    public static final String CTE_7BIT = "7bit";
    public static final String CTE_8BIT = "8bit";
    public static final String CTE_BINARY = "binary";
    private static final boolean DEBUG = true;
    private String subject;
    private String from;
    private Vector addressesVector;
    private String header;
    private String replyTo;
    private String contentType;
    private String charset;
    private String contentTransferEncoding;
    private String xMailer;
    private Date date;
    private String body;

    public Message() {
        this.subject = "";
        this.from = "";
        this.addressesVector = new Vector();
        this.header = "";
        this.replyTo = "";
        this.contentType = CONTYPE_TEXT_HTML;
        this.charset = CHARSET_KOI8_R;
        this.contentTransferEncoding = CTE_BINARY;
        this.xMailer = "BorisPlusMailer";
        this.date = new Date();
        this.body = "";
    }

    public Message(String _subject, String _from, Vector _addressesVector, String _header, String _replyTo, String _contentType, String _charset, String _contentTransferEncoding, String _xMailer, Date _date, String _body) {
        this.subject = _subject;
        this.from = _from;
        this.addressesVector = _addressesVector;
        this.header = _header;
        this.replyTo = _replyTo;
        this.contentType = _contentType;
        this.charset = _charset;
        this.contentTransferEncoding = _contentTransferEncoding;
        this.xMailer = "BorisPlusMailer";
        this.date = new Date();
        this.body = _body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String _subject) {
        this.subject = _subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String _from) {
        this.from = _from;
    }

    public void addAddress(String _address) {
        this.getAddresses().addElement(_address);
    }

    public void deleteAddress(int _index) {
        if (0 < _index && _index <= this.getAddresses().size()) {
            this.getAddresses().removeElementAt(_index);
        }
    }

    public boolean deleteAddress(String _address) {
        return this.getAddresses().removeElement(_address);
    }

    public Vector getAddresses() {
        return this.addressesVector;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String _header) {
        this.header = _header;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String _replyTo) {
        this.replyTo = _replyTo;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String _contentType) {
        this.contentType = _contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String _charset) {
        this.charset = _charset;
    }

    public String getContentTransferEncoding() {
        return this.contentTransferEncoding;
    }

    public void setContentTransferEncoding(String _contentTransferEncoding) {
        this.contentTransferEncoding = _contentTransferEncoding;
    }

    public String getXMailer() {
        return this.xMailer;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date _date) {
        this.date = _date;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String _body) {
        this.body = _body;
    }

    public void addToBody(String _addToBody) {
        this.body = this.body + _addToBody;
    }

    public String toSmtpData() {
        String result = "";
        result = result + "Subject: " + (this.getSubject().length() != 0 ? this.getSubject() : " ") + CRLF;
        if (this.getFrom() != null && this.getFrom().length() != 0) {
            result = result + "From: " + this.getFrom() + CRLF;
        }
        for (int i2 = 0; i2 < this.getAddresses().size(); ++i2) {
            result = result + "To:" + this.getAddresses().elementAt(i2) + CRLF;
        }
        if (this.getHeader() != null && this.getHeader().length() != 0) {
            result = result + this.getHeader();
        }
        if (this.getReplyTo() != null && this.getReplyTo().length() != 0) {
            result = result + "Reply-To: " + this.getReplyTo() + CRLF;
        }
        if (this.getContentType() != null && this.getContentType().length() != 0 && this.getCharset() != null && this.getCharset().length() != 0) {
            result = result + "Content-Type: " + this.getReplyTo() + "; charset=" + this.getCharset() + CRLF;
        }
        if (this.getContentTransferEncoding() != null && this.getContentTransferEncoding().length() != 0) {
            result = result + "Content-Transfer-Encoding: " + this.getContentTransferEncoding() + CRLF;
        }
        if (this.getXMailer() != null && this.getXMailer().length() != 0) {
            result = result + "X-Mailer: " + this.getXMailer() + CRLF;
        }
        if (this.getDate() != null) {
            result = result + "Date: " + this.getDate() + CRLF;
        }
        if (this.getBody() != null && this.getBody().length() != 0) {
            result = result + this.getBody() + CRLF;
        }
        result = result + "\r\n.\r\n";
        return result;
    }
}

