/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class SocketIrc {
    private DataInputStream in;
    private DataOutputStream out;
    private boolean pollmode;
    private boolean connected;
    public static int bytein = 0;
    public static int byteout = 0;

    public SocketIrc(boolean bl) {
        this.pollmode = bl;
        this.connected = false;
    }

    public String connect(String string, int n, String string2) {
        String string3;
        try {
            StreamConnection streamConnection = (StreamConnection)Connector.open((String)("socket://" + string + ":" + n), (int)3);
            this.in = streamConnection.openDataInputStream();
            this.out = streamConnection.openDataOutputStream();
            this.connected = true;
            string3 = this.writeData(string2);
        }
        catch (Exception exception) {
            string3 = jmIrc.language.get("ErrConnect", "" + exception.toString());
        }
        return string3;
    }

    public void disconnect() {
        if (this.connected) {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out.close();
                }
                if (this.in != null) {
                    this.in.close();
                }
                this.connected = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String readLine() {
        String string = null;
        try {
            int n;
            byte[] byArray = new byte[512];
            for (n = 0; n < 512; ++n) {
                int n2 = this.in.read();
                if (n2 == -1) {
                    this.connected = false;
                    return string;
                }
                byArray[n] = (byte)n2;
                if (byArray[n] == 10) break;
            }
            if (n == 512) {
                return null;
            }
            if (n > 0 && byArray[n - 1] == 13) {
                --n;
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            if (byArray2 == null) {
                return null;
            }
            bytein += byArray2.length + 40;
            string = Utils.byteArrayToString(byArray2, Database.Encoding);
        }
        catch (Exception exception) {
            this.connected = false;
        }
        return string;
    }

    public synchronized String writeData(String string) {
        if (string != null && this.connected) {
            try {
                byte[] byArray = Utils.stringToByteArray(string, Database.Encoding);
                this.out.write(byArray);
                byteout += byArray.length;
                this.out.flush();
            }
            catch (Exception exception) {
                this.connected = false;
                return jmIrc.language.get("ErrReadWrite", "" + exception.toString());
            }
        }
        return null;
    }

    public boolean hasDataInBuffer() {
        if (this.pollmode) {
            try {
                return this.in.available() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getBytesIn() {
        return bytein;
    }

    public int getBytesOut() {
        return byteout;
    }
}

