################################################################################
#  .
# 1.          . 
# 2.           :) 
# 3.   ,       .
# 4.     
# :
#	!
#	!
#	!
#	!
#	!
#	!
#	!
#	!
#	!
#	!
#   !
#   ! -   :)
#   !barstat -          
#   !bartop -     
#   !baruser -          
#                   
#   :
#   ! -       
#   ! -         
#   ! -       
#        !ah (   )
#      !bar
###############################################################################
#  :
#  barman.tcl    scripts,     
# source scripts/barman.tcl
#  holidays.txt  imeninnik.txt    data  
################################################################################
# : Soler.   ramok     
################################################################################

namespace eval bar {}

if { ![info exists egglib(ver)] || [expr {$egglib(ver) < 1.2}] } {
    putlog "***********************************************"
    putlog "   egglib_pub NOT FOUND OR VERSION IS TOO OLD!"
    putlog "   Download last version of egglib_pub here:"
    putlog "  http://eggdrop.org.ru/scripts/egglib_pub.zip"
    putlog "***********************************************"
    die
}
setudef flag nopubbar

set bar(version) 2.0
set bar(autors) Soler

#    
set bar(prefix) "!" 
#   dat 
set bar(datadir) data/bar
#    
set bar(holidaysdir) data
#    -    .    
# .  0     
set bar(botuse) 1
#     (      -   1 )
set botcount 2
#    
set bar(take) {
       {  } {  } {  } {  } {  }
       {  } {    }
              }
#  
set bar(give) {
       {    } {   } {    }
       {     } { ,      } { ,    } {     }
              }
set bar(tara) {
       {,  :} {,  :} {,  :}
              } 
set bar(tara2) {
       {,  :} { ,  :} { ,  :}
               }  
set bar(speek) {
       {"  50 "} {"  !"} {"  !"} {" !"}
       {" !  "} {" !"} {",  ?"} {"   !"} {", !   !"} {"    :)"} {"?    !   !"} {"     ?"}  
               }

set bar(drinks)        "beer vodka koniak shampanskoe ersh kokteil vino voda  kofe tea sok protein "
set bar(drinks_ru) "             "
set bar(drinks_doze)   "0.5  0.05  0.05   0.2    0.15     0.2      0.2 0.5 0.2  0.2 0.2 0.5 "
set bar(drinks_grad)   "4    40    40     12     40      8        8  0  0    0   0 0 "

# 
set bar(beer) {                      
   {'Porter'} {'Pilsner Light'} {'Golden Light'} {'Dutch Lager'} {'Pale Ale'} {'Scotch Ale'} {'Light Lager'} 
   {'Golden Ale'} {'American Lager'} {'American Ale'} {'American Blond'} {'American Pilsner Light'} {'Honey Beer'}
   {'Canadian Light'} {'Canadian Red Lager'} {' '} {'LowenBrau'} {''} {' '} 
   {''} {' '} {' '} {' '} {''} {''} {'EFES Pilsner'} 
   {''} {' 2%'} {' 3%'} {''} {' '} {'Tinkoff'} {''} 
   {'p'} {'RAUCH'} {'DRY'} {'DRAFT'} {'ICE BEER'} {' '} {'p '} {'p'}
   {' '} {' '} {' - Lion'}
              }
# 
set bar(vodka) {
       {''} {''} {' '} {''} {' '} {''} {''} 
       {''} {'׸ '} {''}
               } 
# 
set bar(shampanskoe) {
       {' '} {''} {' '} {''} {''}
                     } 
   
# 
 set bar(koniak) {
        {''} {''} {''} {''} {''} {'  *'} {'  *'}
        {'Kromvel'} {'Imperial'} {'Kamerger'}
                 } 
#    
set bar(vino) {
       {''} {'  '} {''} {''} {' '} {' '}
       {'  '}
              }
# 
set bar(sok) {
       {''} {'J7'} {'Gold Premium'} {' '} {'Rich'} {''} {'Frut'} {'Gimmi'} {'RFF'} 
       {'Du'}
             }
# 
set bar(voda) {
       {''} {''} {' '} {' '} {'Pepsi'} {'Coca-Cola'} {'Sprite'} {'7 UP'} 
       {'Fanta'} {''}
              }
# 
set bar(kokteil) {
       {' '} {'Bravo'} {''} {' - '} {'London moon'} {'Chavers'} {'Godzila'}
                 }
# 
set bar(kofe) {
       {'Nescafe'} {'Jacobs'} {'Chibo'} {'Brazerro'} {'Latino Borrokko'} {'Esto'} {'Viva Rosa'}
              }
# 
set bar(tea) {
       {' '} {''} {'Lipton'} {''} {''} {''} {'London'} {'Tau'} {'Cha'}
             }
# 
set bar(protein) {
       {' '} {'Pure Pro'} {'PROBOLIC-SR'} {''} 
             }

set bar(flowers) "\0034@\003\0039}-'-,-'-,-'-,----\003,"

set bar(otvet) {
       {Yes} {No} 
              }
   
#    
foreach d $bar(drinks) d_ru $bar(drinks_ru) {
    bind pub - $bar(prefix)$d    ::bar::${d}count
    bind pub - $bar(prefix)$d_ru ::bar::${d}count
}

bind pub - $bar(prefix)barstat ::bar::barstat
bind pub - $bar(prefix)bartop  ::bar::bartop
bind pub - $bar(prefix)baruser ::bar::baruser
bind pub - $bar(prefix)bar     ::bar::barhelp
bind pub - $bar(prefix)     ::bar::barhelp
bind pub - $bar(prefix)     ::bar::barpohmel
bind pub - $bar(prefix)     ::bar::barflowers
bind pub - $bar(prefix)     ::bar::congratulation
bind pub - $bar(prefix)     ::bar::congratulation
bind pub - $bar(prefix) ::bar::date_showpub
bind pub - $bar(prefix)addholiday ::bar::date_addholiday
bind pub - $bar(prefix)ah ::bar::date_addholiday
bind pub - $bar(prefix) ::bar::sovet
bind pub - $bar(prefix) ::bar::romashka

### ::bar::updatestat
#  (  1)    $drink 
#  $chan
###
proc ::bar::updatestat {chan drink} {
        global bar
        set count 0
        set lnum 0

#       
file mkdir $bar(datadir)/$chan

       #    
       set data [::egglib::readdata $bar(datadir)/$chan/$drink.dat]
       foreach line $data {
           incr lnum           
               set count [lindex [split $line "+"] 1]           
       }

       #   
       set count [incr count]

       #   
       set data [lreplace $data [expr $lnum-1] [expr $lnum-1] "+$count"]
       ::egglib::writedata $bar(datadir)/$chan/$drink.dat $data
}
proc ::bar::readcount {chan drink} {
        global bar
        set count 0
        
        set data [::egglib::readdata $bar(datadir)/$chan/$drink.dat]
        foreach line $data {
                      
               set count [lindex [split $line "+"] 1]
           
       }
return $count       
     
}
#  

proc ::bar::barmsg {args nick chan } {
        global botnick bar
    regsub -all -- {[\{\}]} $bar(action) {} bar(action)

    if {$args == ""} {
        putserv "PRIVMSG $chan :\001ACTION $bar(action) $nick\001" 
    } elseif {$args == $botnick} {
       if {$bar(botuse) == 1} {
           putserv "PRIVMSG $chan :$nick,   !   !"
       } else {
           putserv "PRIVMSG $chan :\001ACTION $bar(action) $args\001"
       }
    } elseif {[onchan $args $chan]} {
        putserv "PRIVMSG $chan :\001ACTION $bar(action) $args\001"
    } else {
        putserv "NOTICE $nick :$args     $chan"
    }
}

# 
proc ::bar::ershcount { nick uhost hand chan args } {
        global bar
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
set args [lindex $args 0]

set say {
{"!    ?"}
{" ?  !"}
{", !"}
{"  !"}
{"0_0     !"}
{"    ? :)"}
{"   ,   !"}
{"            !    ?"}
{"-"}
}
set bar(action) [list  50 . [lindex $bar(vodka) [rand [llength $bar(vodka)]]], 50   [lindex $bar(beer) [rand [llength $bar(beer)]]], 50   [lindex $bar(shampanskoe) [rand [llength $bar(shampanskoe)]]],  : [lindex $say [rand [llength $say]]],       ]

::bar::updatestat $chan "ersh" 
::bar::barmsg $args $nick $chan 

 }

# 

proc ::bar::beercount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
    
set args [lindex $args 0]
              
set bar(beer_tara) {
{ }
{ }
{ }
{ }
}
set bar(beer_tara2) {
{,  :}
{,  :}
{ ,  :}
} 
 set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(beer_tara) [rand [llength $bar(beer_tara)]]] [lindex $bar(beer) [rand [llength $bar(beer)]]]     [lindex $bar(beer_tara2) [rand [llength $bar(beer_tara2)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]

::bar::updatestat $chan "beer" 
::bar::barmsg $args $nick $chan 

}
 
#########
 
proc ::bar::vodkacount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(vodka_tara) {
{ }
{ }
}
set bar(tara) {
{,  :}
{,  :}
{,  :}
} 
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(vodka_tara) [rand [llength $bar(vodka_tara)]]] [lindex $bar(vodka) [rand [llength $bar(vodka)]]]     [lindex $bar(tara) [rand [llength $bar(tara)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
 
       ::bar::updatestat $chan "vodka"
       ::bar::barmsg $args $nick $chan
}

########## 

proc ::bar::koniakcount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(koniak_tara) {
{ }
{   }
}
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(koniak_tara) [rand [llength $bar(koniak_tara)]]] [lindex $bar(koniak) [rand [llength $bar(koniak)]]]     [lindex $bar(tara) [rand [llength $bar(tara)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
   
       ::bar::updatestat $chan "koniak"
       ::bar::barmsg $args $nick $chan 
}
########## 

proc ::bar::shampanskoecount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(shampanskoe_tara) {
{ }
 }
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(shampanskoe_tara) [rand [llength $bar(shampanskoe_tara)]]] [lindex $bar(shampanskoe) [rand [llength $bar(shampanskoe)]]]     [lindex $bar(tara2) [rand [llength $bar(tara2)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
   
       ::bar::updatestat $chan "shampanskoe"
       ::bar::barmsg $args $nick $chan
 }

######### 

proc ::bar::vodacount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(voda_tara) {
{ }
{  }
 }
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(voda_tara) [rand [llength $bar(voda_tara)]]] [lindex $bar(voda) [rand [llength $bar(voda)]]]     [lindex $bar(tara2) [rand [llength $bar(tara2)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
  
       ::bar::updatestat $chan "voda"
       ::bar::barmsg $args $nick $chan
}
############ 

proc ::bar::kokteilcount { nick uhost hand chan args } {
        global bar
  
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
  
set args [lindex $args 0]
              
set bar(kokteil_tara2) {
{   :}
{  }
 }
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]]  [lindex $bar(kokteil) [rand [llength $bar(kokteil)]]]     [lindex $bar(kokteil_tara2) [rand [llength $bar(kokteil_tara2)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
    
       ::bar::updatestat $chan "kokteil"
       ::bar::barmsg $args $nick $chan
}

########## 

proc ::bar::vinocount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(vino_tara) {
{ }
{   }
}
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(vino_tara) [rand [llength $bar(vino_tara)]]] [lindex $bar(vino) [rand [llength $bar(vino)]]]     [lindex $bar(tara2) [rand [llength $bar(tara2)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]

        ::bar::updatestat $chan "vino"
        ::bar::barmsg $args $nick $chan
}
############## 

proc ::bar::kofecount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(kofe_tara) {
{ }
{ }
}
 
set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(kofe_tara) [rand [llength $bar(kofe_tara)]]] [lindex $bar(kofe) [rand [llength $bar(kofe)]]]    ,      : [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
    
       ::bar::updatestat $chan "kofe"
       ::bar::barmsg $args $nick $chan
}
############### 

proc ::bar::sokcount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]
              
set bar(sok_tara) {
{ }
{  }
}
 set bar(action) [list [lindex $bar(take) [rand [llength $bar(take)]]] [lindex $bar(sok_tara) [rand [llength $bar(sok_tara)]]] [lindex $bar(sok) [rand [llength $bar(sok)]]]     [lindex $bar(tara2) [rand [llength $bar(tara2)]]] [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
  
 
       ::bar::updatestat $chan "sok"
       ::bar::barmsg $args $nick $chan
}
############## 

proc ::bar::teacount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]

set bar(take_act) {
       {  }
	   {  }
	   {  }
              }
              
set bar(action) [list [lindex $bar(take_act) [rand [llength $bar(take_act)]]] [lindex $bar(tea) [rand [llength $bar(tea)]]],       : [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
   
       ::bar::updatestat $chan "tea"
       ::bar::barmsg $args $nick $chan
}
############## 

proc ::bar::proteincount { nick uhost hand chan args } {
        global bar
   
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  002$chan\002   ."
                        return
                }
   
set args [lindex $args 0]

set bar(take_act) {
       {   }
	   {   }
	
              }
              
set bar(action) [list [lindex $bar(take_act) [rand [llength $bar(take_act)]]] [lindex $bar(protein) [rand [llength $bar(protein)]]],       : [lindex $bar(speek) [rand [llength $bar(speek)]]] [lindex $bar(give) [rand [llength $bar(give)]]]]
   
       ::bar::updatestat $chan "protein"
       ::bar::barmsg $args $nick $chan
}

#  
proc ::bar::barpohmel { nick uhost hand chan args } {
        global bar
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
set args [lindex $args 0]
            
set bar(pohmel) {
     {  ,      }
     {   ,     } 
     {  ,     } 
     { }
     {   ,        }
}
set say {
    {" !"} {"   !...   ! ?"} {" ?"}
    {"---"} {"      ! :)"} {",   ! :)"}
}
set nsay {
    {  :     !!! :)}
    {     ,    !}
    { -  ,   !}
    { -  !     !}
    {  ,   II . !}
}
set bar(action) " [lindex $bar(pohmel) [rand [llength $bar(pohmel)]]]  : [lindex $say [rand [llength $say]]], "
            if {$args !=""} {
                ::bar::barmsg $args $nick $chan
                ::egglib::outn $args "$args! [lindex $nsay [rand [llength $nsay]]]"
            } else {
                ::bar::barmsg $args $nick $chan
                ::egglib::outn $nick "$nick! [lindex $nsay [rand [llength $nsay]]]"
            }

} 

#   :)
# 
proc ::bar::barflowers { nick uhost hand chan args } {
      global bar botnick

                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  $chan   ."
                        return
                }   
set args [lindex $args 0]              
set bar(action) " $args $bar(flowers)"
                if {$args == $nick} {
                putserv "PRIVMSG $chan : ?  !" 
                return
                }
                if {$args !="" && [onchan $args $chan] && $args != $botnick }  {
                        putserv "PRIVMSG $chan :\001ACTION $bar(action).   ,    ,    $args: \"   $nick! :)\"\001"
                } else {
                ::bar::barmsg $args $nick $chan
                }        
}
# 
proc ::bar::congratulation { nick uhost hand chan args } {
      global bar botnick
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  $chan   ."
                        return
                }   
set args [lindex $args 0]
#    
set usersline [chanlist $chan]
#      
regsub -all -- $args $usersline {} usersline

set bar(action) "   : $usersline - ,  $args $bar(flowers)     : ! ! !    $args :)!!!"

                if {$args !="" && [onchan $args $chan]} {
                        putserv "PRIVMSG $chan :$bar(action)."
                } elseif {$args ==""} {
                putserv "notice $nick : , $nick,  !         $bar(prefix) $nick :)" 
                        } else {
                        putserv "NOTICE $nick :$args     $chan" 
                        
                }          
}
# 
proc ::bar::date_showpub {nick uhost hand chan args} {
global bar
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  $chan   ."
                        return
                }   
        set fopen [open $bar(holidaysdir)/holidays.txt r]
        set fopenim [open $bar(holidaysdir)/imeninnik.txt r]
        set t [clock format [clock seconds] -format "%d %m"]
        set delstr [split $t " "]
        
        while {[gets $fopen line]>=0} {
                if {([lindex $line 0]==[lindex $delstr 0]) && ([lindex $line 1]==[lindex $delstr 1])} {
                ::egglib::out $nick $chan "   : [lreplace $line 0 1]"
                
                }
        }
        close $fopen
##########
# 
##########
        while {[gets $fopenim line]>=0} {
                if {([lindex $line 0]==[lindex $delstr 0]) && ([lindex $line 1]==[lindex $delstr 1])} {
                        ::egglib::out $nick $chan "  : [lreplace $line 0 1] -    ! :)"
                }
        }
        close $fopenim
}
#   ()
proc ::bar::date_addholiday {nick uhost hand chan args} {
        global bar
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  $chan   ."
                        return
                }   
                if {![matchattr $nick $bar(lah) $chan] && ![matchattr $nick nm|- $chan] } {
               ::egglib::outn $nick "$nick!        "
                        } else {
                        set fopen [open $bar(holidaysdir)/holidays.txt "r"]
                        set delargs [split [lindex $args 0] " "]
                        set day [lindex $delargs 0]
                        set month [lindex $delargs 1]
                        set args [lrange $delargs 2 end]
                        set data [read -nonewline $fopen]
                close $fopen
                        set lines [split $data "\n"]
                        set where_to_insert 0
                        set reason "  -   . ,  !!! - \"$bar(prefix)ah 1 12     .!\""
                        
                if {[regexp -- {[^0-9]} $day]} {
                        ::egglib::outn $nick $reason
                        return
                } elseif {[regexp -- {[^0-9]} $month]} {
                        ::egglib::outn $nick $reason
                        return
                } elseif {$args == "" || $day == "" || $month == ""} {
                        ::egglib::outn $nick $reason
                        return
                } else {
                #     
                set fopen [open $bar(holidaysdir)/holidays.txt "w"]
                puts $fopen [join [linsert $lines $where_to_insert "$day $month $args"] "\n"]
                close $fopen
                ::egglib::outn $nick "$nick!  !"
                }
                }
}
       

##################################--#####################################

proc ::bar::barstat { nick uhost hand chan args } {
        global bar 

                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }           

        set reason "    $chan  ():::"
        set alc 0
        set noalc 0

        foreach d $bar(drinks) d_ru $bar(drinks_ru) d_grad $bar(drinks_grad) {
        set count [::bar::readcount $chan $d]
        set reason "$reason $d_ru: $count |"

        #       
        if {$d_grad == 0} {
            set noalc [expr $noalc + $count]
        } else {
            set alc [expr $alc + $count]
        }
    }

    set reason "$reason"

        if {$alc > $noalc} {::egglib::out $nick $chan "$reason      !"
        } elseif {$alc < $noalc} {::egglib::out $nick $chan "$reason    ,  !"
        } else {::egglib::out $nick $chan "$reason !    !"}
}

##############   

proc ::bar::bartop { nick uhost hand chan text } {
        global bar

                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }

        set reason "    $chan  ():::"
        set usersnum [llength [chanlist $chan]] 
        foreach d $bar(drinks) d_ru $bar(drinks_ru) d_doze $bar(drinks_doze) {
        set reason "$reason $d_ru: [expr [::bar::readcount $chan $d] * $d_doze] |"
    }

    ::egglib::out $nick $chan $reason
}

##############     1   

proc ::bar::baruser { nick uhost hand chan text } {
        global bar botcount 

                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }

#    
set usersnum [llength [chanlist $chan]]
#   
set users [expr $usersnum-$botcount]

set reason "  ,  $users    ,       ():"

 foreach d $bar(drinks) d_ru $bar(drinks_ru) d_doze $bar(drinks_doze) {
        set reason "$reason $d_ru: [format %.2f [expr [::bar::readcount $chan $d] * $d_doze / $users]] |"
    }      
::egglib::out $nick $chan $reason

}

##############  

proc ::bar::sovet { nick uhost hand chan args } {
        global bar
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
set args [lindex $args 0]

set bar(otvet_yes) {
		{ !   !} {    !}
		{   !} {. !     :)!}
              }
set bar(otvet_no) {
        {  !} {  !}
		{  !  !} {   !}
              }

set bar(variant_otveta) [list [lindex $bar(otvet) [rand [llength $bar(otvet)]]]]
set bar(otvet_yes) [list [lindex $bar(otvet_yes) [rand [llength $bar(otvet_yes)]]]]
set bar(otvet_no) [list [lindex $bar(otvet_no) [rand [llength $bar(otvet_no)]]]]

if {$bar(variant_otveta)=="Yes"} {
putserv "PRIVMSG $chan :$nick, [lindex $bar(otvet_yes) [rand [llength bar(otvet_yes)]]]"
} else {

putserv "PRIVMSG $chan :$nick, [lindex $bar(otvet_no) [rand [llength bar(otvet_no)]]]"

 }	}			
 
 ############## 

proc ::bar::romashka { nick uhost hand chan args } {
        global bar
                if {[channel get $chan nopubbar]} {
                        putserv "NOTICE $nick :  \002$chan\002   ."
                        return
                }
set args [lindex $args 0]


set bar(romashka) {
        {} { }
		{} {} {  } {  }
              }

set bar(romashka_vbr) [lindex $bar(romashka) [rand [llength $bar(romashka)]]]

putserv "PRIVMSG $chan ::  -  .  - .    -   !"
putserv "PRIVMSG $chan :$nick,   - $bar(romashka_vbr)...."

 	}			

############## Help

proc ::bar::barhelp { nick uhost hand chan args } {
   global botnick  bar
        putserv "PRIVMSG $nick $chan:   $botnick: $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix), $bar(prefix) $bar(prefix)barstat, $bar(prefix)bartop, $bar(prefix)baruser"
        putserv "PRIVMSG $nick $chan: : $bar(prefix) - $botnick   , $bar(prefix) <> - $botnick   <>, $bar(prefix)barstat -      $bar(prefix)bartop -       , $bar(prefix)baruser -       , $bar(prefix) -   :)."
        putserv "PRIVMSG $nick $chan:  - $bar(prefix) <> -   , $bar(prefix) <> -         , $bar(prefix) -      ..  :)!"
		putserv "PRIVMSG $nick $chan:      ,     $bar(prefix), $botnick  .      "
        putserv "PRIVMSG $nick $chan:      - $bar(prefix)"
        
  
 }

putlog "::: barman.tcl loaded ::: v$bar(version) by $bar(autors) loaded"
